#include "gameloop.h"
#include "NFont.h"

using namespace PL;
using namespace std;

extern SDL_Surface* firePic1;

extern NFont blackFont;
void showComplete(GameState* gs);


void GameUpdate::update(PL_State* state)
{
    GameState* s = static_cast<GameState*>(state);
	Player* p = s->player;

	if(p->hp >= 0)
	{
        if(s->keystate[SDLK_UP] || s->keystate[SDLK_w])
            p->moveUp();
        else if(s->keystate[SDLK_DOWN] || s->keystate[SDLK_s])
            p->moveDown();
        else
        {
            p->stopUp();
            p->stopDown();
        }
        if(s->keystate[SDLK_LEFT] || s->keystate[SDLK_a])
            p->moveLeft();
        else if(s->keystate[SDLK_RIGHT] || s->keystate[SDLK_d])
            p->moveRight();
        else
        {
            p->stopLeft();
            p->stopRight();
        }
	}

	for(list<House>::iterator e = s->houses.begin(); e != s->houses.end(); e++)
	{
	    e->update(s, s->dt);
	}

	if(p->hp >= 0)
        p->update(s, s->dt);

	for(list<Fire>::iterator e = s->fires.begin(); e != s->fires.end(); e++)
	{
	    e->update(s, s->dt);
	}

	p->updateEffects(s, s->dt);

	for(list<Fire>::iterator e = s->fires.begin(); e != s->fires.end();)
	{
	    e->updateEffects(s, s->dt);
	    if(e->size < 1)
	    {
	        e = s->fires.erase(e);
	        continue;
	    }
	    e++;
	}

	for(list<House>::iterator e = s->houses.begin(); e != s->houses.end();)
	{
	    if(e->hp < 0)
	    {
	        s->lostHouses.push_back(*e);
	        e = s->houses.erase(e);
	        continue;
	    }
	    e++;
	}

	if(!s->complete)
	{
        if(s->fires.size() == 0 || s->player->hp <= 0)
        {
            s->complete = true;
            if(s->bonus)
                s->nextLevelTimer = 15.000;
            else
                s->nextLevelTimer = 2.000;
        }
	}
	else
	{
	    s->nextLevelTimer -= s->dt;
	    if(s->nextLevelTimer < 0)
        {
            if(s->player->hp > 0)
                s->won = true;
            else
                s->won = false;
            s->resetFrameTime = true;
            s->dt = 0;
            s->player->velx = s->player->vely = 0;
            showComplete(s);
            if(!s->won || !s->loadNextLevel())
            {
                s->done = true;
            }
        }
	}

}

void GameDraw::draw(PL_State* state)
{
    GameState* s = static_cast<GameState*>(state);
	Player* p = s->player;

	SPG_Draw(s->grass, s->screen, 0, 0);


	for(list<House>::iterator e = s->houses.begin(); e != s->houses.end(); e++)
	{
	    e->draw(s->screen);
	}

	if(p->hp >= 0)
        p->draw(s->screen);
    else
        SPG_DrawCenter(firePic1, s->screen, p->x, p->y);

	for(list<Fire>::iterator e = s->fires.begin(); e != s->fires.end(); e++)
	{
	    e->draw(s->screen);
	}

	int mx, my;
	SDL_GetMouseState(&mx, &my);
	p->drawAim(s, mx, my);
	p->drawLife(s);

	if(s->bonus)
        blackFont.draw(0, 0, "%.2f", s->nextLevelTimer);

	SDL_Flip(s->screen);
}

bool GameEvent::handleEvent(PL_State* state, SDL_Event& event)
{
    GameState* s = static_cast<GameState*>(state);
	Player* p = s->player;

    if(event.type == SDL_KEYDOWN)
    {
//        if(event.key.keysym.sym == SDLK_RETURN)
//        {
//            showComplete(s);
//            s->loadNextLevel();
//        }
    }
    else if(event.type == SDL_MOUSEBUTTONDOWN)
    {
        if(event.button.button == SDL_BUTTON_LEFT)
        {
            if(p->hp >= 0)
                p->startBurn(s, event.button.x, event.button.y);
        }
    }
    else if(event.type == SDL_MOUSEBUTTONUP)
    {
        if(event.button.button == SDL_BUTTON_LEFT)
        {
            p->endBurn();
        }
    }

    return true;
}




